use master
GO

set nocount on 

--set to 0 to skip updating the A4Survey_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @ClientPayload01 nvarchar(max) = N'
-- Script 6600_66405
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[A4S_sp_ReplicatePanelDatabase]'') AND type in (N''P'', N''PC''))
    DROP PROCEDURE [dbo].[A4S_sp_ReplicatePanelDatabase]
'

declare @ClientPayload02 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_ReplicatePanelDatabase]
AS
BEGIN
  SET NOCOUNT ON
  DECLARE @surveyDatabase nvarchar(64) = DB_NAME()
  DECLARE @clientId int = dbo.GetClientId(@surveyDatabase) 
  DECLARE @clientIdString nvarchar(8) = CONVERT(nvarchar, @clientId)
  DECLARE @panelDatabase nvarchar(40) = ''A4Panel_Client_'' + @clientIdString
  DECLARE @surveyId int
  DECLARE @surveySchema nvarchar(40)
  DECLARE @synchronizationVersion int 
  DECLARE @sqlcmd nvarchar(max) 

  -- Get last version from DB
  SELECT TOP 1 @synchronizationVersion = [Version] FROM [ChangeTrackingVersions] ORDER BY [Version] DESC
 
  IF @synchronizationVersion < CHANGE_TRACKING_CURRENT_VERSION()
  BEGIN 
   BEGIN TRY
    SET TRANSACTION ISOLATION LEVEL SNAPSHOT;
    BEGIN TRAN

    PRINT ''Updating version: '' + CAST(@synchronizationVersion AS NVARCHAR)   

    IF (SELECT COUNT(*) FROM sys.change_tracking_tables WHERE min_valid_version > @synchronizationVersion AND min_valid_version > begin_version) > 0
    BEGIN
   RAISERROR (N''Synchronization version is too old - Call A4S_sp_ResetPanelDatabase to reset all the data.'', 16, -1)
    END
    ELSE
    BEGIN
  -- Schemas
  DECLARE surveyCursor CURSOR LOCAL FOR SELECT * FROM A4S_fn_GetPanelSurveyIds()
    
  OPEN surveyCursor;
  FETCH NEXT FROM surveyCursor INTO @surveyId;
  WHILE @@FETCH_STATUS = 0 BEGIN
   DECLARE @surveyIdString nvarchar(10) = CONVERT(nvarchar, @surveyId) 
   SET @surveySchema = ''Survey_'' + @clientIdString + ''_'' + @surveyIdString
     
   ----------- Respondents 
   -- Insert   
   PRINT ''Replicating ['' + @surveySchema + ''].[Respondent] - Inserted''
   SET @sqlcmd = N''INSERT INTO ['' + @panelDatabase + ''].[dbo].[PanelistRespondents] ([SurveyId], [PanelistId], [RespondentId], [RespondentActive], [RespondentOnline])
   SELECT @surveyId, r.[panelistId], r.[ResRespondent], r.[ResActive], r.[ResOnline]
   FROM ['' + @surveySchema + ''].[Respondent] AS r 
   INNER JOIN ['' + @panelDatabase +  ''].[dbo].[Panelists] p ON r.PanelistId = p.Id
   INNER JOIN CHANGETABLE(CHANGES ['' + @surveySchema + ''].[Respondent], @synchronizationVersion) AS ct ON r.[ResRespondent] = ct.[ResRespondent]
   WHERE ct.SYS_CHANGE_OPERATION = ''''I'''' AND r.[PanelistId] IS NOT NULL AND NOT EXISTS (SELECT 1 FROM ['' + @panelDatabase + ''].[dbo].[PanelistRespondents] WHERE SurveyId = @surveyId AND PanelistId = r.[panelistId] AND RespondentId = r.[ResRespondent] )''
   EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int, @surveyId int'', @synchronizationVersion = @synchronizationVersion, @surveyId = @surveyId
   PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)
     
   -- Update
   PRINT ''Replicating ['' + @surveySchema + ''].[Respondent] - Updated''
   SET @sqlcmd = N''UPDATE pr SET [RespondentActive] = r.[ResActive], [RespondentOnline] = r.[ResOnline]
   FROM ['' + @panelDatabase + ''].[dbo].[PanelistRespondents] AS pr
   INNER JOIN ['' + @surveySchema + ''].[Respondent] AS r ON pr.[RespondentId] = r.[ResRespondent]
   INNER JOIN CHANGETABLE(CHANGES ['' + @surveySchema + ''].[Respondent], @synchronizationVersion) AS ct ON r.[ResRespondent] = ct.[ResRespondent]
   WHERE ct.SYS_CHANGE_OPERATION = ''''U'''' AND r.[PanelistId] IS NOT NULL AND pr.[SurveyId] = @surveyId''
   EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int, @surveyId int'', @synchronizationVersion = @synchronizationVersion, @surveyId = @surveyId
   PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)
     
   -- Delete
   PRINT ''Replicating ['' + @surveySchema + ''].[Respondent] - Deleted''
   SET @sqlcmd = N''DELETE ['' + @panelDatabase + ''].[dbo].[PanelistRespondents] WHERE EXISTS(
   SELECT [ResRespondent] FROM CHANGETABLE(CHANGES ['' + @surveySchema + ''].[Respondent], @synchronizationVersion) AS ct
   WHERE ct.SYS_CHANGE_OPERATION = ''''D'''' AND [SurveyId] = @surveyId AND '' + @panelDatabase + ''.[dbo].[PanelistRespondents].[RespondentId] = ct.[ResRespondent])''
   EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int, @surveyId int'', @synchronizationVersion = @synchronizationVersion, @surveyId = @surveyId
   PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)
     
   ----------- Responses
   -- Insert   
   PRINT ''Replicating ['' + @surveySchema + ''].[Response] - Inserted''
   SET @sqlcmd = N''INSERT INTO ['' + @panelDatabase + ''].[dbo].[PanelistSurveyResponses] ([SurveyId], [RespondentId], [PanelistId], [VariableId], [VariableName], [Matrix], [Mention], [Content])
   SELECT @surveyId, r.[RpsRespondent], pr.[PanelistId], r.[RpsVariableId], r.RpsQuestion, r.[RpsMatrix], r.[RpsMention], r.[RpsContent]
   FROM ['' + @surveySchema + ''].[Response] AS r
   INNER JOIN ['' + @panelDatabase +  ''].[dbo].[PanelistRespondents] pr ON r.[RpsRespondent] = pr.[RespondentId]
   JOIN CHANGETABLE(CHANGES ['' + @surveySchema + ''].[Response], @synchronizationVersion) AS ct
   ON r.[RpsRespondent] = ct.[RpsRespondent] AND r.[RpsQuestion] = ct.[RpsQuestion] AND r.[RpsMatrix] = ct.[RpsMatrix] AND r.[RpsMention] = ct.[RpsMention]
   WHERE ct.SYS_CHANGE_OPERATION = ''''I'''' AND pr.[SurveyId] = @surveyId''
   EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int, @surveyId int'', @synchronizationVersion = @synchronizationVersion, @surveyId = @surveyId
   PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)
     
   -- Update
   PRINT ''Replicating ['' + @surveySchema + ''].[Response] - Updated''
   SET @sqlcmd = N''UPDATE psr SET [Content] = r.[RpsContent]
   FROM ['' + @panelDatabase + ''].[dbo].[PanelistSurveyResponses] AS psr
   JOIN ['' + @surveySchema + ''].[Response] AS r 
   ON psr.[RespondentId] = r.[RpsRespondent] AND psr.[VariableName] = r.[RpsQuestion] AND psr.[Matrix] = r.[RpsMatrix] AND psr.[Mention] = r.[RpsMention]
   INNER JOIN CHANGETABLE(CHANGES ['' + @surveySchema + ''].[Response], @synchronizationVersion) AS ct
   ON r.[RpsRespondent] = ct.[RpsRespondent] AND r.[RpsQuestion] = ct.[RpsQuestion] AND r.[RpsMatrix] = ct.[RpsMatrix] AND r.[RpsMention] = ct.[RpsMention]
   WHERE ct.SYS_CHANGE_OPERATION = ''''U'''' AND psr.[SurveyId] = @surveyId''     
   EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int, @surveyId int'', @synchronizationVersion = @synchronizationVersion, @surveyId = @surveyId
   PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)
     
   ---- Delete
   PRINT ''Replicating ['' + @surveySchema + ''].[Response] - Deleted''
   SET @sqlcmd = N''DELETE ['' + @panelDatabase + ''].[dbo].[PanelistSurveyResponses] WHERE EXISTS (
   SELECT * FROM CHANGETABLE(CHANGES '' + @surveySchema + ''.[Response], @synchronizationVersion) AS ct 
   WHERE ct.SYS_CHANGE_OPERATION = ''''D'''' AND [SurveyId] = @surveyId AND '' + @panelDatabase + ''.[dbo].[PanelistSurveyResponses].[RespondentId] = ct.[RpsRespondent] 
   AND '' + @panelDatabase + ''.[dbo].[PanelistSurveyResponses].[VariableName] = ct.[RpsQuestion] AND '' + @panelDatabase + ''.[dbo].[PanelistSurveyResponses].[Matrix] = ct.[RpsMatrix] 
   AND '' + @panelDatabase + ''.[dbo].[PanelistSurveyResponses].[Mention] = ct.[RpsMention])''
   EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int, @surveyId int'', @synchronizationVersion = @synchronizationVersion, @surveyId = @surveyId
   PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)
     
   ----------- Historic
   ---- Insert  
   PRINT ''Replicating ['' + @surveySchema + ''].[Historic] - Inserted'' 
   SET @sqlcmd = N''
   DECLARE @surveyActivityHistory TABLE (
	[Id] INT,
	[Index] INT,
	[DispositionCode] TINYINT
   )

   MERGE INTO ['' + @panelDatabase + ''].[dbo].[ActivityHistories] AS destination
   USING (
    SELECT
		pr.[PanelistId],
		h.[HisRespondent] AS [RespondentId],
		h.[HisCallDate] AS [DateTime],
		h.[HisCallNumber] AS [Index],
		h.[HisResult] AS [DispositionCode]
    FROM ['' + @surveySchema + ''].[Historic] AS h
    INNER JOIN ['' + @panelDatabase +  ''].[dbo].[PanelistRespondents] pr ON h.[HisRespondent] = pr.[RespondentId]
    INNER JOIN CHANGETABLE(CHANGES ['' + @surveySchema + ''].[Historic], @synchronizationVersion) AS ct ON h.[HisRespondent] = ct.[HisRespondent] AND h.[HisCallNumber] = ct.[HisCallNumber]
    LEFT JOIN ['' + @panelDatabase + N''].[dbo].[ActivityHistories] ah ON ah.[SurveyId] = @surveyId AND h.[HisRespondent] = ah.[RespondentId]
	LEFT JOIN  ['' + @panelDatabase + N''].[dbo].[ActivityHistories_SurveyActivityHistory] sah ON ah.[Id] = sah.[Id] AND h.[HisCallNumber] = sah.[Index]
	WHERE ct.SYS_CHANGE_OPERATION = ''''I''''
		AND pr.[SurveyId] = @surveyId
		AND sah.[Id] IS NULL
   ) AS source
   ON 1 = 0 -- never match
   WHEN NOT MATCHED THEN
	INSERT ([PanelistId], [SurveyId], [RespondentId], [DateTime])
	VALUES (source.[PanelistId], @surveyId, source.[RespondentId], source.[DateTime])
   OUTPUT inserted.[Id], source.[Index], source.[DispositionCode]
   INTO @surveyActivityHistory;

   INSERT INTO ['' + @panelDatabase + ''].[dbo].[ActivityHistories_SurveyActivityHistory] ([Id], [Index], [DispositionCode])
   SELECT [Id], [Index], [DispositionCode]
   FROM @surveyActivityHistory;''   
   EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int, @surveyId int'', @synchronizationVersion = @synchronizationVersion, @surveyId = @surveyId     
   PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)
     
   -- Update
   PRINT ''Replicating ['' + @surveySchema + ''].[Historic] - Updated'' 
   SET @sqlcmd = N''UPDATE sah SET [DispositionCode] = h.[HisResult]
   FROM ['' + @panelDatabase + ''].[dbo].[ActivityHistories] AS ah
   INNER JOIN ['' + @panelDatabase + ''].[dbo].[ActivityHistories_SurveyActivityHistory] AS sah ON ah.[Id] = sah.[Id]
   INNER JOIN ['' + @surveySchema + ''].[Historic] AS h ON ah.[RespondentId] = h.[HisRespondent] AND sah.[Index] = h.[HisCallNumber]
   INNER JOIN CHANGETABLE(CHANGES ['' + @surveySchema + ''].[Historic], @synchronizationVersion) AS ct
   ON h.[HisRespondent] = ct.[HisRespondent] AND h.[HisCallNumber] = ct.[HisCallNumber]
   WHERE ct.SYS_CHANGE_OPERATION = ''''U'''' AND ah.[SurveyId] = @surveyId''
   EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int, @surveyId int'', @synchronizationVersion = @synchronizationVersion, @surveyId = @surveyId     
   PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)
     
   -- Delete
   PRINT ''Replicating ['' + @surveySchema + ''].[Historic] - Deleted'' 
   SET @sqlcmd = N''DELETE ['' + @panelDatabase + ''].[dbo].[ActivityHistories] WHERE EXISTS(
   SELECT * FROM ['' + @panelDatabase + ''].[dbo].[ActivityHistories] AS ah
   INNER JOIN ['' + @panelDatabase + ''].[dbo].[ActivityHistories_SurveyActivityHistory] AS sah ON ah.[Id] = sah.[Id]
   INNER JOIN CHANGETABLE(CHANGES ['' + @surveySchema + ''].[Historic], @synchronizationVersion) AS ct ON ah.[RespondentId] = ct.[HisRespondent] AND sah.[Index] = ct.[HisCallNumber]
   WHERE ct.SYS_CHANGE_OPERATION = ''''D'''' AND ah.[SurveyId] = @surveyId AND ['' + @panelDatabase + ''].[dbo].[ActivityHistories].[Id] = ah.[Id])''
   EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int, @surveyId int'', @synchronizationVersion = @synchronizationVersion, @surveyId = @surveyId
   PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)
     
   FETCH NEXT FROM surveyCursor INTO @surveyId;
  END
  CLOSE surveyCursor
  DEALLOCATE surveyCursor

  ----------- Users   
  -- Insert
  PRINT ''Replicating [dbo].[Users] - Inserted'' 
  SET @sqlcmd = N''INSERT INTO ['' + @panelDatabase + ''].[dbo].[Users] ([Id], [UserName], [FirstName], [LastName], [DisplayName])
  SELECT u.[Id], u.[UserName], u.[FirstName], u.[LastName], u.[FirstName] + '''' '''' + u.[LastName]
  FROM [dbo].[Users] AS u
  INNER JOIN CHANGETABLE(CHANGES [dbo].[Users], @synchronizationVersion) AS ct ON u.[Id] = ct.[Id]
  WHERE ct.SYS_CHANGE_OPERATION = ''''I''''''
  EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion
  PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)

  -- Update  
  PRINT ''Replicating [dbo].[Users] - Updated''
  SET @sqlcmd = N''UPDATE pu SET [UserName] = u.[UserName], [FirstName] = u.[FirstName], [LastName] = u.[LastName], [DisplayName] = u.[FirstName] + '''' '''' + u.[LastName]
  FROM ['' + @panelDatabase + ''].[dbo].[Users] AS pu
  INNER JOIN [dbo].[Users] AS u ON pu.[Id] = u.[Id]
  INNER JOIN CHANGETABLE(CHANGES [dbo].[Users], @synchronizationVersion) AS ct ON u.[Id] = ct.[Id]
  WHERE ct.SYS_CHANGE_OPERATION = ''''U''''''
  EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion
  PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)

  -- Delete
  PRINT ''Replicating [dbo].[Users] - Deleted''
  SET @sqlcmd = N''DELETE ['' + @panelDatabase + ''].[dbo].[Users] WHERE EXISTS(
  SELECT * FROM CHANGETABLE(CHANGES [dbo].[Users], @synchronizationVersion) AS ct
  WHERE ct.SYS_CHANGE_OPERATION = ''''D'''' AND ['' + @panelDatabase + ''].[dbo].[Users].[Id] = ct.[Id])''
  EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion
  PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)

  ----------- EmailInvitations
  -- Insert
  PRINT ''Replicating [dbo].[VEM_EmailInvitation] - Inserted''
  SET @sqlcmd = N''INSERT INTO ['' + @panelDatabase + ''].[dbo].[EmailInvitations] ([Id], [SurveyId], [Name], [TemplateId], [TemplateName], [SendDateTime], [Status])
  SELECT ei.[Id], ei.[ProjectId], ei.[Name], ei.[DefaultTemplateId], ei.[DefaultTemplateName], ei.[SendDateTime], ei.[Status]
  FROM [dbo].VEM_EmailInvitation AS ei
  INNER JOIN CHANGETABLE(CHANGES [dbo].[VEM_EmailInvitation], @synchronizationVersion) AS ct ON ei.[Id] = ct.[Id]
  WHERE ct.SYS_CHANGE_OPERATION = ''''I''''''
  EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion
  PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)

  -- Update
  PRINT ''Replicating [dbo].[VEM_EmailInvitation] - Updated''
  SET @sqlcmd = N''UPDATE pei SET [Name]=ei.[Name], [TemplateId]=ei.[DefaultTemplateId], [TemplateName]=ei.[DefaultTemplateName], [SendDateTime]=ei.[SendDateTime], [Status]=ei.[Status]
  FROM ['' + @panelDatabase + ''].[dbo].[EmailInvitations] AS pei
  INNER JOIN [dbo].[VEM_EmailInvitation] AS ei ON pei.[Id] = ei.[Id]
  INNER JOIN CHANGETABLE(CHANGES [dbo].[VEM_EmailInvitation], @synchronizationVersion) AS ct ON ei.[Id] = ct.[Id]
  WHERE ct.SYS_CHANGE_OPERATION = ''''U''''''
  EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion
  PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)

  -- Delete
  PRINT ''Replicating [dbo].[VEM_EmailInvitation] - Deleted''
  SET @sqlcmd = N''DELETE ['' + @panelDatabase + ''].[dbo].[EmailInvitations] WHERE EXISTS( 
  SELECT * FROM CHANGETABLE(CHANGES [dbo].[VEM_EmailInvitation], @synchronizationVersion) AS ct
  WHERE ct.SYS_CHANGE_OPERATION = ''''D'''' AND ['' + @panelDatabase + ''].[dbo].[EmailInvitations].[Id] = ct.[Id])''
  EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion
  PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)

  ----------- ActivityHistories_EmailActivityHistory
  -- Insert
  PRINT ''Replicating [dbo].[VEM_InvitationHistory] - Inserted''
  SET @sqlcmd = N''
  DECLARE @emailActivityHistory TABLE (
	[Id] INT,
	[EmailInvitationId] INT,
	[EmailHistoryId] INT,
	[EmailInvitationStatus] TINYINT,
	[TemplateId] INT
   )

   MERGE INTO ['' + @panelDatabase + ''].[dbo].[ActivityHistories] AS destination
   USING (
	SELECT
		pr.[PanelistId],
		i.[ProjectId] AS [SurveyId],
		h.[RespondentId],
		h.[TimeStampGMT] AS [DateTime],
		i.[Id] AS [EmailInvitationId],
		h.[Id] AS [EmailHistoryId],
		CASE
			WHEN h.[Status] = ''''Sent'''' THEN 1
			WHEN h.[Status] = ''''Started'''' THEN 2
			WHEN h.[Status] = ''''Bounced''''THEN 3
			WHEN h.[Status] = ''''Completed'''' THEN 4
			ELSE 0
		END AS [EmailInvitationStatus],
		i.[DefaultTemplateId] AS [TemplateId]
	FROM [dbo].[VEM_InvitationHistory] h
	INNER JOIN [dbo].[VEM_EmailInvitation] i on h.[InvitationId] = i.[Id]
	INNER JOIN ['' + @panelDatabase +  ''].[dbo].[PanelistRespondents] pr ON i.[ProjectId] = pr.[SurveyId] AND h.[RespondentId] = pr.[RespondentId]
	INNER JOIN CHANGETABLE(CHANGES [dbo].[VEM_InvitationHistory], @synchronizationVersion) AS ct ON h.[Id] = ct.[Id]
	WHERE ct.SYS_CHANGE_OPERATION = ''''I''''
   ) AS source
   ON 1 = 0 -- never match
   WHEN NOT MATCHED THEN
	INSERT ([PanelistId], [SurveyId], [RespondentId], [DateTime])
	VALUES (source.[PanelistId], source.[SurveyId], source.[RespondentId], source.[DateTime])
   OUTPUT inserted.[Id], source.[EmailInvitationId], source.[EmailHistoryId], source.[EmailInvitationStatus], source.[TemplateId]
   INTO @emailActivityHistory;

   INSERT INTO ['' + @panelDatabase + ''].[dbo].[ActivityHistories_EmailActivityHistory] ([Id], [EmailInvitationId], [EmailHistoryId], [EmailInvitationStatus], [TemplateId])
   SELECT [Id], [EmailInvitationId], [EmailHistoryId], [EmailInvitationStatus], [TemplateId]
   FROM @emailActivityHistory;''
  EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion
  PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)

  -- Delete  
  PRINT ''Replicating [dbo].[VEM_InvitationHistory] - Deleted''
  SET @sqlcmd = N''DELETE ['' + @panelDatabase + ''].[dbo].[ActivityHistories] WHERE EXISTS(
  SELECT * FROM ['' + @panelDatabase + ''].[dbo].[ActivityHistories_EmailActivityHistory] eah
  INNER JOIN CHANGETABLE(CHANGES [dbo].[VEM_InvitationHistory], @synchronizationVersion) AS ct ON eah.[EmailHistoryId] = ct.[Id]
  WHERE ct.SYS_CHANGE_OPERATION = ''''D'''' AND ['' + @panelDatabase + ''].[dbo].[ActivityHistories].[Id] = eah.[Id])''
  EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion
  PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)

  ----------- ActivityHistories_SmsActivityHistory
  -- Insert
  PRINT ''Replicating [dbo].[Distributions_SMS_History] - Inserted''
  SET @sqlcmd = N''
  DECLARE @smsActivityHistory TABLE (
	[Id] INT,
	[SmsInvitationId] INT,
	[SmsInvitationStatus] TINYINT
   )

   MERGE INTO ['' + @panelDatabase + ''].[dbo].[ActivityHistories] AS destination
   USING (
	SELECT
		pr.[PanelistId],
		d.[SurveyId],
		h.[RespondentId],
		h.[TimeStamp] AS [DateTime],
		d.[Id] AS [SmsInvitationId],
		h.[Status] AS [SmsInvitationStatus]
	FROM [dbo].[Distributions_SMS_History] h
	INNER JOIN [dbo].[Distributions] d ON h.[DistributionId] = d.[Id]
	INNER JOIN ['' + @panelDatabase +  ''].[dbo].[PanelistRespondents] pr ON d.[SurveyId] = pr.[SurveyId] AND h.[RespondentId] = pr.[RespondentId]
	INNER JOIN CHANGETABLE(CHANGES [dbo].[Distributions_SMS_History], @synchronizationVersion) AS ct ON h.[Id] = ct.[Id]
	WHERE ct.SYS_CHANGE_OPERATION = ''''I''''
   ) AS source
   ON 1 = 0 -- never match
   WHEN NOT MATCHED THEN
	INSERT ([PanelistId], [SurveyId], [RespondentId], [DateTime])
	VALUES (source.[PanelistId], source.[SurveyId], source.[RespondentId], source.[DateTime])
   OUTPUT inserted.[Id], source.[SmsInvitationId], source.[SmsInvitationStatus]
   INTO @smsActivityHistory;

   INSERT INTO ['' + @panelDatabase + ''].[dbo].[ActivityHistories_SmsActivityHistory] ([Id], [SmsInvitationId], [SmsInvitationStatus])
   SELECT [Id], [SmsInvitationId], [SmsInvitationStatus]
   FROM @smsActivityHistory;''
  EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion
  PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)

  -- Delete  
  PRINT ''Replicating [dbo].[Distributions_SMS_History] - Deleted''
  SET @sqlcmd = N''DELETE ['' + @panelDatabase + ''].[dbo].[ActivityHistories] WHERE EXISTS(
  SELECT * FROM ['' + @panelDatabase + ''].[dbo].[ActivityHistories_SmsActivityHistory] sah
  INNER JOIN CHANGETABLE(CHANGES [dbo].[Distributions_SMS_History], @synchronizationVersion) AS ct ON sah.[Id] = ct.[Id]
  WHERE ct.SYS_CHANGE_OPERATION = ''''D'''' AND ['' + @panelDatabase + ''].[dbo].[ActivityHistories].[Id] = sah.[Id])''
  EXEC sp_executesql @sqlcmd, N''@synchronizationVersion int'', @synchronizationVersion = @synchronizationVersion
  PRINT ''Done! Affected rows: '' + CAST(@@ROWCOUNT AS NVARCHAR)
    END

    UPDATE [dbo].[ChangeTrackingVersions] SET [Updated] = GETDATE() WHERE [Version] = @synchronizationVersion
    INSERT INTO [dbo].[ChangeTrackingVersions] ([Version]) VALUES (CHANGE_TRACKING_CURRENT_VERSION())

    COMMIT TRAN
   END TRY
   BEGIN CATCH
    IF @@TRANCOUNT > 0 ROLLBACK TRAN

    DECLARE @ErrorMessage NVARCHAR(4000);
    DECLARE @ErrorSeverity INT;
    DECLARE @ErrorState INT;
    SELECT @ErrorMessage = ERROR_MESSAGE(), @ErrorSeverity = ERROR_SEVERITY(), @ErrorState = ERROR_STATE();

    UPDATE [dbo].[ChangeTrackingVersions] SET [ErrorMessage] = @ErrorMessage WHERE [Version] = @synchronizationVersion      
   
    RAISERROR (@ErrorMessage, @ErrorSeverity, @ErrorState);
   END CATCH
  END
  ELSE
  BEGIN
   PRINT ''Panel database is already up to date''
  END
END
'

--declare @SurveyPayload01 nvarchar(max) = N'waitfor delay ''0:00:01'''

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)
create table #Survey (
	DBName nvarchar(128),
	SchemaName nvarchar(128),
	Processed tinyint default 0
)
create table #SurveyVerif (
	DBName nvarchar(128),
	SchemaName nvarchar(128)
)
create table #SurveysDone (
	DBName nvarchar(128) collate database_default,
	SchemaName nvarchar(128) collate database_default
)
declare @AllDone bit = 0, 
        @TotalClients int, 
		@TotalSurveys int, 
		@ClientCounter int, 
		@SurveyCounter int, 
		@ThisClient nvarchar(128), 
		@ThisSurvey nvarchar(128), 
		@ClientCursor cursor, 
		@SurveyCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalClients = 0, @TotalSurveys = 0, @ClientCounter = 0, @SurveyCounter = 0
	insert into #DB 
	select 'A4Survey_Client_' + cast(Id as nvarchar(16)), 0 from Acuity4.dbo.Client
	     
    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Survey_Client_Template', 0)

	select @TotalClients = count(*) 
	       from #DB
	
	set @ClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @ClientCursor
	fetch next from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @ClientCounter += 1
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #Survey select ''' + @ThisClient + ''', SchemaName, 0 from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName, 0 from #SurveysDone'
		exec @DBSQL @SQL
		select @StatusMessage = 'Updating client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ClientCounter / @TotalClients
		raiserror (@StatusMessage, 0, 1, @ThisClient, @ClientCounter, @TotalClients, @StatusPercent) with nowait
		
		select @SQL = replace(replace(@ClientPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@ClientPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		update #DB set Processed = 1 where current of @ClientCursor
		fetch next from @ClientCursor into @ThisClient
	end


	close @ClientCursor
	deallocate @ClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Survey_Client_Template';
      SET @SQL = 'USE Acuity4;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
drop table #Survey
drop table #SurveyVerif
drop table #SurveysDone